/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.hwmca.base.logd;

import com.ibm.hwmca.base.logd.EventLogData;
import com.ibm.hwmca.base.logd.EventLogInitTable;
import com.ibm.hwmca.base.logd.HexInfo;
import com.ibm.hwmca.base.logd.LogErrorIdsLogD;
import com.ibm.hwmca.fw.HException;
import com.ibm.hwmca.fw.log.FrameworkClassLogInfo;
import com.ibm.hwmca.fw.log.FrameworkLog;
import com.ibm.hwmca.fw.tasklet.PanelBean;
import com.ibm.hwmca.fw.tasklet.PanelTaskletRequest;
import com.ibm.hwmca.fw.util.HexString;
import com.ibm.hwmca.fw.util.Trace;
import com.ibm.hwmca.fw.util.cparser.ParserObj;
import com.ibm.ui.framework.Capabilities;
import com.ibm.ui.framework.ColumnDescriptor;
import com.ibm.ui.framework.IllegalUserDataException;
import com.ibm.ui.framework.ItemDescriptor;
import com.ibm.ui.framework.TaskActionEvent;

public class HexDisplayerBean
extends PanelBean
implements LogErrorIdsLogD {
    private static final String TRACE_MASKT = "XLOGDBHT";
    private static final String TRACE_MASKF = "XLOGDBHF";
    private static final String TRACE_MASKD = "XLOGDBHD";
    private static final FrameworkClassLogInfo _logInfo = new FrameworkClassLogInfo(85, "LogDisplayer");
    public static final transient int NUMBER_OF_COLUMNS_IN_HEX_TABLE = 6;
    public static final transient int BYTES_IN_ROW = 16;
    public static final transient int BYTES_IN_ELEMENT = 4;
    public static final transient int NUMBER_COLUMNS_OF_JUST_HEX_DATA = 4;
    public static final transient int COLUMN_INDEX_CHAR_DATA = 5;
    private transient int _numRows;
    private transient boolean _displayDataAsEbcdic;
    public static final String CANCEL = "CANCEL";
    public static final String BUTTON_OK = "OkButton";
    public static final String BUTTON_ASCII = "AsciiButton";
    public static final String BUTTON_EBCDIC = "EbcdicButton";
    private transient ItemDescriptor[] m_idEventLogTable;
    private transient ColumnDescriptor[] m_cdEventLogTableStructure;
    private transient int[] m_iEventLogTableSelection;
    private transient String m_sEndAddrOutput;
    private transient ItemDescriptor[] m_idHexTable;
    private HexInfo _hexInfo;
    private transient byte[] _hexData;
    private transient EventLogData _eventLogData;
    private transient int _hexDataLen;
    private transient ColumnDescriptor[] m_cdHexTableStructure;
    private transient int[] m_iHexTableSelection;
    private transient StringBuffer _strCharBuf;
    private transient StringBuffer _strHexBuf;
    private static final char[] ASCII_ARRAY = new char[]{'.', '.', '.', '.', '.', '.', '.', '.', '.', '.', '.', '.', '.', '.', '.', '.', '.', '.', '.', '.', '.', '.', '.', '.', '.', '.', '.', '.', '.', '.', '.', '.', ' ', '!', '\"', '#', '$', '%', '&', '\'', '(', ')', '*', '+', ',', '-', '.', '/', '0', '1', '2', '3', '4', '5', '6', '7', '8', '9', ':', ';', '<', '=', '>', '?', '@', 'A', 'B', 'C', 'D', 'E', 'F', 'G', 'H', 'I', 'J', 'K', 'L', 'M', 'N', 'O', 'P', 'Q', 'R', 'S', 'T', 'U', 'V', 'W', 'X', 'Y', 'Z', '[', '\\', ']', '^', '_', '`', 'a', 'b', 'c', 'd', 'e', 'f', 'g', 'h', 'i', 'j', 'k', 'l', 'm', 'n', 'o', 'p', 'q', 'r', 's', 't', 'u', 'v', 'w', 'x', 'y', 'z', '{', '|', '}', '~', '.', '.', '.', '.', '.', '.', '.', '.', '.', '.', '.', '.', '.', '.', '.', '.', '.', '.', '.', '.', '.', '.', '.', '.', '.', '.', '.', '.', '.', '.', '.', '.', '.', '.', '.', '.', '.', '.', '.', '.', '.', '.', '.', '.', '.', '.', '.', '.', '.', '.', '.', '.', '.', '.', '.', '.', '.', '.', '.', '.', '.', '.', '.', '.', '.', '.', '.', '.', '.', '.', '.', '.', '.', '.', '.', '.', '.', '.', '.', '.', '.', '.', '.', '.', '.', '.', '.', '.', '.', '.', '.', '.', '.', '.', '.', '.', '.', '.', '.', '.', '.', '.', '.', '.', '.', '.', '.', '.', '.', '.', '.', '.', '.', '.', '.', '.', '.', '.', '.', '.', '.', '.', '.', '.', '.', '.', '.', '.', '.'};
    private static final char[] EBCDIC_ARRAY = new char[]{'.', '.', '.', '.', '.', '.', '.', '.', '.', '.', '.', '.', '.', '.', '.', '.', '.', '.', '.', '.', '.', '.', '.', '.', '.', '.', '.', '.', '.', '.', '.', '.', ' ', '.', '.', '.', '.', '.', '.', '.', '.', '.', '.', '.', '.', '.', '.', '.', '.', '.', '.', '.', '.', '.', '.', '.', '.', '.', '.', '.', '.', '.', '.', '.', ' ', '.', '.', '.', '.', '.', '.', '.', '.', '.', '.', '.', '<', '(', '+', '|', '&', '.', '.', '.', '.', '.', '.', '.', '.', '.', '!', '$', '*', ')', ';', '.', '-', '/', '.', '.', '.', '.', '.', '.', '.', '.', '.', ',', '%', '_', '>', '?', '.', '.', '.', '.', '.', '.', '.', '.', '.', '.', ':', '#', '@', '\'', '=', '\"', '.', 'a', 'b', 'c', 'd', 'e', 'f', 'g', 'h', 'i', '.', '{', '.', '(', '+', '.', '.', 'j', 'k', 'l', 'm', 'n', 'o', 'p', 'q', 'r', '.', '}', '.', '.', '.', '.', '.', '.', 's', 't', 'u', 'v', 'w', 'x', 'y', 'z', '.', '.', '.', '.', '.', '.', '.', '.', '.', '.', '.', '.', '.', '.', '.', '.', '.', '.', '.', '.', '.', '.', '.', 'A', 'B', 'C', 'D', 'E', 'F', 'G', 'H', 'I', '.', '.', '.', '.', '.', '.', '.', 'J', 'K', 'L', 'M', 'N', 'O', 'P', 'Q', 'R', '.', '.', '.', '.', '.', '.', '.', '.', 'S', 'T', 'U', 'V', 'W', 'X', 'Y', 'Z', '.', '.', '.', '.', '.', '.', '0', '1', '2', '3', '4', '5', '6', '7', '8', '9', '.', '.', '.', '.', '.', '.'};

    public static char getASCIIChar(int i) {
        return ASCII_ARRAY[i];
    }

    public static char getEBCDICChar(int i) {
        return EBCDIC_ARRAY[i];
    }

    public void setHexInfo(HexInfo hexInfo) throws IllegalUserDataException {
        this._hexInfo = hexInfo;
    }

    public ColumnDescriptor[] getEventLogTableRowStructure() {
        return this.m_cdEventLogTableStructure;
    }

    public int getEventLogTableRowStatus() {
        return 3;
    }

    public int getEventLogTableRowCount() {
        return 1;
    }

    public ItemDescriptor[] getEventLogTableRowAt(int index) {
        return this.m_idEventLogTable;
    }

    public void setEventLogTableRowAt(int index, ItemDescriptor[] items) throws IllegalUserDataException {
        this.m_idEventLogTable = items;
    }

    public int[] getEventLogTableSelection() {
        return this.m_iEventLogTableSelection;
    }

    public void setEventLogTableSelection(int[] selected) throws IllegalUserDataException {
        this.m_iEventLogTableSelection = selected;
    }

    public String getEndAddrOutput() {
        return this.m_sEndAddrOutput;
    }

    public void setEndAddrOutput(String s) throws IllegalUserDataException {
        this.m_sEndAddrOutput = s;
    }

    public ColumnDescriptor[] getHexTableRowStructure() {
        return this.m_cdHexTableStructure;
    }

    public int getHexTableRowStatus() {
        return 3;
    }

    public int getHexTableRowCount() {
        return this._numRows;
    }

    public ItemDescriptor[] getHexTableRowAt(int index) {
        return this.getHexTableDescriptorData(index);
    }

    public void setHexTableRowAt(int index, ItemDescriptor[] items) throws IllegalUserDataException {
    }

    public int[] getHexTableSelection() {
        return this.m_iHexTableSelection;
    }

    public void setHexTableSelection(int[] selected) throws IllegalUserDataException {
        this.m_iHexTableSelection = selected;
    }

    public Capabilities getCapabilities() {
        return null;
    }

    public void verifyChanges() throws IllegalUserDataException {
    }

    public void save() {
    }

    public void prepare() {
        this.setUpTitleAndButton();
    }

    private void setUpTitleAndButton() {
        if (this._displayDataAsEbcdic) {
            Trace.trace(TRACE_MASKF, "table data will be displayed as EBCDIC ");
            this.userTaskManager.setCaptionText("CharacterCol", "EBCDIC");
            this.userTaskManager.setShown(BUTTON_EBCDIC, false);
            this.userTaskManager.setShown(BUTTON_ASCII, true);
        } else {
            Trace.trace(TRACE_MASKF, "table data will be displayed as ASCII ");
            this.userTaskManager.setCaptionText("CharacterCol", "ASCII");
            this.userTaskManager.setShown(BUTTON_EBCDIC, true);
            this.userTaskManager.setShown(BUTTON_ASCII, false);
        }
    }

    public void load() {
        Trace.trace(TRACE_MASKF, "-> HexDisplayerBean.load()");
        this._strCharBuf = new StringBuffer(16);
        this._strHexBuf = new StringBuffer(9);
        this._hexData = this._hexInfo.getHexData();
        this._eventLogData = this._hexInfo.getEventLogData();
        this._displayDataAsEbcdic = false;
        this._hexDataLen = this._hexData.length;
        this._numRows = this._hexDataLen / 16;
        if (this._hexDataLen - this._numRows * 16 != 0) {
            ++this._numRows;
        }
        Trace.trace(TRACE_MASKF, "HexDisplayer: numRows=" + this._numRows + " hexDataLen=" + this._hexDataLen);
        this.m_idHexTable = new ItemDescriptor[6];
        int i = 0;
        while (i < 6) {
            this.m_idHexTable[i] = new ItemDescriptor();
            ++i;
        }
        this.m_sEndAddrOutput = HexString.toHex(this._hexDataLen - 1, false).toUpperCase();
        this.m_iEventLogTableSelection = new int[0];
        this.m_cdEventLogTableStructure = new ColumnDescriptor[0];
        this.m_cdHexTableStructure = new ColumnDescriptor[0];
        this.m_iHexTableSelection = new int[0];
        this.m_idEventLogTable = EventLogInitTable.setEventTableData(this._eventLogData);
        Trace.trace(TRACE_MASKF, "<- HexDisplayerBean.load()");
    }

    private ItemDescriptor[] getHexTableDescriptorData(int row) {
        short address;
        Trace.trace(TRACE_MASKF, "-> getHexTableDescriptorData() row=" + row);
        this._strCharBuf.setLength(0);
        this.m_idHexTable[0].setName("Address" + row);
        if (this._hexDataLen > 65535) {
            address = row * 16;
            this.m_idHexTable[0].setTitle(HexString.toHex((int)address, true).toUpperCase());
        } else {
            address = (short)(row * 16);
            this.m_idHexTable[0].setTitle(HexString.toHex(address, true).toUpperCase());
        }
        int index = row * 16;
        int i = 1;
        while (i <= 4) {
            this._strHexBuf.setLength(0);
            int j = 0;
            while (index < this._hexDataLen && j < 4) {
                if (this._displayDataAsEbcdic) {
                    this._strCharBuf.append(HexDisplayerBean.getEBCDICChar(ParserObj.toInt(this._hexData, 1, index)));
                } else {
                    this._strCharBuf.append(HexDisplayerBean.getASCIIChar(ParserObj.toInt(this._hexData, 1, index)));
                }
                this._strHexBuf.append(HexString.toHex(this._hexData[index], true));
                if (j == 1) {
                    this._strHexBuf.append(" ");
                }
                ++index;
                ++j;
            }
            this.m_idHexTable[i].setName("Col" + i + row);
            this.m_idHexTable[i].setTitle(this._strHexBuf.toString().toUpperCase());
            ++i;
        }
        this.m_idHexTable[5].setName("Char" + row);
        this.m_idHexTable[5].setTitle(this._strCharBuf.toString());
        Trace.trace(TRACE_MASKF, "<- getHexTableDescriptorData()");
        return this.m_idHexTable;
    }

    public void panelAction(TaskActionEvent evt) {
        block4: {
            PanelTaskletRequest request = null;
            try {
                Trace.trace(TRACE_MASKT, "-> HexDisplayerBean.panelAction()");
                String command = evt.getActionCommand();
                Trace.trace(TRACE_MASKF, "command = " + command);
                request = new PanelTaskletRequest();
                request.setData("event", evt);
                request.setData("panelName", "HexPanel");
                if (command.equals(BUTTON_EBCDIC)) {
                    Trace.trace(TRACE_MASKF, "processing ebcdic button");
                    this._displayDataAsEbcdic = true;
                    this.setUpTitleAndButton();
                    this.userTaskManager.refreshAllElements();
                    break block4;
                }
                if (command.equals(BUTTON_ASCII)) {
                    Trace.trace(TRACE_MASKF, "processing ascii button");
                    this._displayDataAsEbcdic = false;
                    this.setUpTitleAndButton();
                    this.userTaskManager.refreshAllElements();
                    break block4;
                }
                this.postTaskletRequest(request);
            }
            catch (Exception e) {
                Trace.trace(TRACE_MASKF, "Error caught in HexDisplayerBean.panelAction() exc = " + e);
                HException he = new HException(e);
                new FrameworkLog(_logInfo, 1301, he).log();
                request.setData("panelError", "terminate");
                this.postTaskletRequest(request);
            }
        }
    }
}

